package GUI;



/**
 * This application that requires the following additional files:
 *   TreeDemoHelp.html
 *    arnold.html
 *    bloch.html
 *    chan.html
 *    jls.html
 *    swingtutorial.html
 *    tutorial.html
 *    tutorialcont.html
 *    vm.html
 */
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

import doABC.ClassInfo;
import doABC.CpoolInfo;
import doABC.ExceptionInfo;
import doABC.InstanceInfo;
import doABC.ItemInfo;
import doABC.MetadataInfo;
import doABC.MethodBodyInfo;
import doABC.MethodInfo;
import doABC.OptionDetail;
import doABC.OptionInfo;
import doABC.ScriptInfo;
import doABC.TraitInfo;
import FlashReader.AbcFile;
import FlashReader.DoABC;
import FlashReader.SWF;
import FlashReader.Tag;
import Main.Main;
import java.net.URL;
import java.util.ArrayList;
import java.awt.Dimension;
import java.awt.GridLayout;

public class TreeView extends JPanel
                      implements TreeSelectionListener {
    private JEditorPane htmlPane;
    private JTree tree;
    private SWF swf;
    //Optionally play with line styles.  Possible values are
    //"Angled" (the default), "Horizontal", and "None".
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";
    private DefaultMutableTreeNode top;
    
    //Optionally set the look and feel.
    private static boolean useSystemLookAndFeel = false;

    
    public TreeView(SWF swf) {
        super(new GridLayout(1,0));
        this.swf = swf;
        //Create the nodes.
        top =
            new DefaultMutableTreeNode("SWF");
       

        //Create a tree that allows one selection at a time.
        tree = new JTree(top);
        //tree.setCellRenderer(new MultiLineCellRenderer());

        tree.getSelectionModel().setSelectionMode
                (TreeSelectionModel.SINGLE_TREE_SELECTION);

        //Listen for when the selection changes.
        tree.addTreeSelectionListener(this);

        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            tree.putClientProperty("JTree.lineStyle", lineStyle);
        }

        //Create the scroll pane and add the tree to it. 
        JScrollPane treeView = new JScrollPane(tree);

        //Create the HTML viewing pane.
        htmlPane = new JEditorPane();
        htmlPane.setEditable(false);
 
        initHelp();
        JScrollPane htmlView = new JScrollPane(htmlPane);

        //Add the scroll panes to a split pane.
        JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        splitPane.setTopComponent(treeView);
        splitPane.setBottomComponent(htmlView);

        Dimension minimumSize = new Dimension(100, 50);
        htmlView.setMinimumSize(minimumSize);
        treeView.setMinimumSize(minimumSize);
        splitPane.setDividerLocation(100); 
        splitPane.setPreferredSize(new Dimension(500, 300));

        //Add the split pane to this panel.
        add(splitPane);
    }
    
    public JTree getTree(){
    	return tree;
    }
    
    
    public void refersh(){
    	DefaultTreeModel model = (DefaultTreeModel) tree.getModel();
    	
    	 top.removeAllChildren();
    	 model.reload();
    }

    /** Required by TreeSelectionListener interface. */
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                           tree.getLastSelectedPathComponent();

        if (node == null) return;

        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {

        	if (nodeInfo.getClass() == CpoolInfo.class){
        		CpoolInfo m = (CpoolInfo) nodeInfo;
        		displayURL(m.String());
        	}
        	else if (nodeInfo.getClass() == MethodInfo.class){
        		MethodInfo m = (MethodInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == MetadataInfo.class){
        		MetadataInfo m = (MetadataInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == InstanceInfo.class){
        		InstanceInfo m = (InstanceInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == ClassInfo.class){
        		ClassInfo m = (ClassInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == ScriptInfo.class){
        		ScriptInfo m = (ScriptInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == MethodBodyInfo.class){
        		MethodBodyInfo m = (MethodBodyInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == OptionInfo.class){
        		OptionInfo m = (OptionInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == TraitInfo.class){
        		TraitInfo m = (TraitInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == ItemInfo.class){
        		ItemInfo m = (ItemInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == ExceptionInfo.class){
        		ExceptionInfo m = (ExceptionInfo) nodeInfo;
        		displayURL(m.String());
        	}else if (nodeInfo.getClass() == OptionDetail.class){
        		OptionDetail m = (OptionDetail) nodeInfo;
        		displayURL(m.String());
        	}
            
        } else {

        }
        
        
        //if (nodeInfo.getClass() == String.class){
        if (!node.isLeaf()) {
	    	if (nodeInfo.toString().contains("DoABC")){
	    		displayURL(SWF.msgs.getString("doABC"));
	    	}
	    	else if (nodeInfo.toString().contains("cpool_info")){
	    		displayURL(SWF.msgs.getString("cpool_info"));
	    	}
	    	else if (nodeInfo.toString().contains("MethodInfo")){
	    		displayURL(SWF.msgs.getString("method_info"));
	    	}
	    	else if (nodeInfo.toString().contains("MetadataInfo")){
	    		displayURL(SWF.msgs.getString("metadata_info"));
	    	}
	    	else if (nodeInfo.toString().contains("InstanceInfo")){
	    		displayURL(SWF.msgs.getString("instance_info"));
	    	}
	    	else if (nodeInfo.toString().contains("ClassInfo")){
	    		displayURL(SWF.msgs.getString("class_info"));
	    	}
	    	else if (nodeInfo.toString().contains("ScriptInfo")){
	    		displayURL(SWF.msgs.getString("script_info"));
	    	}
	    	else if (nodeInfo.toString().contains("MethodBodyInfo")){
	    		displayURL(SWF.msgs.getString("method_body_info"));
	    	}
        }
    	
    	
        //}
    }



    private void initHelp() {
  
        displayURL(SWF.msgs.getString("doABC"));
    }

    private void displayURL(String data) {
        
		htmlPane.setText(data);
               
    }
    public void refreshTree() {
    	
    	DefaultTreeModel model = (DefaultTreeModel) tree.getModel();
    	model.reload();
    	//model.nodeStructureChanged( o);
	}  
    
    
    
    
    
    public void createNodes() {
	
    	
		for(Tag tag: SWF.EN_Tag){
			
			if(tag.getopcode() == 72 || tag.getopcode() == 82){
				DoABC doABC = (DoABC)tag;
				AbcFile abc = doABC.getAbcData();
				
				DefaultMutableTreeNode tagCategory = new DefaultMutableTreeNode(tag);
				
				top.add(tagCategory);
				
				DefaultMutableTreeNode category = new DefaultMutableTreeNode(abc.getConstant_pool());
			
			
					
					CpoolInfo cpool =abc.getConstant_pool();
					
								       
			        DefaultMutableTreeNode categoryp2 = new DefaultMutableTreeNode(cpool);
			        category.add(categoryp2);
			        tagCategory.add(category); 
			
			        DefaultMutableTreeNode category2 = new DefaultMutableTreeNode("MethodInfo");
			        tagCategory.add(category2);  
			        
			        
			        for (int i = 0; i < abc.ENmethod_info.size();i++){
			        	DefaultMutableTreeNode categoryp1 = new DefaultMutableTreeNode(abc.ENmethod_info.get(i).toString2());
			
			        	categoryp1.add(new DefaultMutableTreeNode(abc.ENmethod_info.get(i)));
			        	
			        	if (abc.ENmethod_info.get(i).getOinfo() != null ){
			            	DefaultMutableTreeNode categoryp3 = new DefaultMutableTreeNode(abc.ENmethod_info.get(i).getOinfo().toString2());
			            	
			            	categoryp3.add(new DefaultMutableTreeNode(abc.ENmethod_info.get(i).getOinfo()));
			            	
			        		ArrayList <OptionDetail> option_detail = abc.ENmethod_info.get(i).getOinfo().getOption_detail();
			        		for (int ii = 0; ii < option_detail.size();ii++){
			        			categoryp3.add(new DefaultMutableTreeNode(option_detail.get(ii)));
			        		}
			        		
			        		categoryp1.add(categoryp3);
			      
			        	}
			        	category2.add(categoryp1);
			        }
			        
			        DefaultMutableTreeNode category3 = new DefaultMutableTreeNode("MetadataInfo");
			        tagCategory.add(category3); 
			            
			        for (int i = 0; i < abc.ENmetadata_info.size();i++){
			        	
			        	DefaultMutableTreeNode categoryp1 = new DefaultMutableTreeNode(abc.ENmetadata_info.get(i).toString2());
			
			        	categoryp1.add(new DefaultMutableTreeNode(abc.ENmetadata_info.get(i)));
			        	
			        	if (abc.ENmetadata_info.get(i).getItem_info() != null ){
			        		for (int ii =0 ; ii < abc.ENmetadata_info.get(i).getItem_info().size();ii++)
			            		categoryp1.add(new DefaultMutableTreeNode(abc.ENmetadata_info.get(i).getItem_info().get(ii)));
			            	
			        	}
			        	category3.add(categoryp1);
			        }
			        
			        DefaultMutableTreeNode category4 = new DefaultMutableTreeNode("InstanceInfo");
			        tagCategory.add(category4);  
			        
			        for (int i = 0; i < abc.ENinstance_info.size();i++){
			        	DefaultMutableTreeNode categoryp1 = new DefaultMutableTreeNode(abc.ENinstance_info.get(i).toString2());
			
			        	categoryp1.add(new DefaultMutableTreeNode(abc.ENinstance_info.get(i)));
			        	
			        	if (abc.ENinstance_info.get(i).getTinfo() != null ){
			        		for (int ii =0 ; ii < abc.ENinstance_info.get(i).getTinfo().size();ii++)
			            		categoryp1.add(new DefaultMutableTreeNode(abc.ENinstance_info.get(i).getTinfo().get(ii)));
			            	
			        	}
			        	category4.add(categoryp1);
			        }
			
			      
			        DefaultMutableTreeNode category5 = new DefaultMutableTreeNode("ClassInfo");
			        tagCategory.add(category5);
			        
			        for (int i = 0; i < abc.ENclass_info.size();i++){
			        	DefaultMutableTreeNode categoryp1 = new DefaultMutableTreeNode(abc.ENclass_info.get(i).toString2());
			
			        	categoryp1.add(new DefaultMutableTreeNode(abc.ENclass_info.get(i)));
			        	
			        	if (abc.ENclass_info.get(i).getTinfo() != null ){
			        		for (int ii =0 ; ii < abc.ENclass_info.get(i).getTinfo().size();ii++)
			            		categoryp1.add(new DefaultMutableTreeNode(abc.ENclass_info.get(i).getTinfo().get(ii)));
			            	
			        	}
			        	category5.add(categoryp1);
			        }
			
			        
			        
			        DefaultMutableTreeNode category6 = new DefaultMutableTreeNode("ScriptInfo");
			        tagCategory.add(category6);
			        
			        for (int i = 0; i < abc.ENscript_info.size();i++){
			        	DefaultMutableTreeNode categoryp1 = new DefaultMutableTreeNode(abc.ENscript_info.get(i).toString2());
			
			        	categoryp1.add(new DefaultMutableTreeNode(abc.ENscript_info.get(i)));
			        	
			        	if (abc.ENscript_info.get(i).getTinfo() != null ){
			        		for (int ii =0 ; ii < abc.ENscript_info.get(i).getTinfo().size();ii++)
			            		categoryp1.add(new DefaultMutableTreeNode(abc.ENscript_info.get(i).getTinfo().get(ii)));
			            	
			        	}
			        	category6.add(categoryp1);
			        }
			        
			        
			        
			        DefaultMutableTreeNode category7 = new DefaultMutableTreeNode("MethodBodyInfo");
			        tagCategory.add(category7);
			
			        for (int i = 0; i < abc.ENmethod_body_info.size();i++){
			        	DefaultMutableTreeNode categoryp1 = new DefaultMutableTreeNode(abc.ENmethod_body_info.get(i).toString2());
			
			        	categoryp1.add(new DefaultMutableTreeNode(abc.ENmethod_body_info.get(i)));
			        	
			        	if (abc.ENmethod_body_info.get(i).getTinfo() != null ){
			        		for (int ii =0 ; ii < abc.ENmethod_body_info.get(i).getTinfo().size();ii++)
			            		categoryp1.add(new DefaultMutableTreeNode(abc.ENmethod_body_info.get(i).getTinfo().get(ii)));
			            	
			        	}
			        	
			        	if (abc.ENmethod_body_info.get(i).getException_info() != null ){
			        		for (int ii =0 ; ii < abc.ENmethod_body_info.get(i).getException_info().size();ii++)
			            		categoryp1.add(new DefaultMutableTreeNode(abc.ENmethod_body_info.get(i).getException_info().get(ii)));
			            	
			        	}
			        	
			        	category7.add(categoryp1);
			        }
		     
			}else{
		        //DefaultMutableTreeNode category = new DefaultMutableTreeNode(tag);
		        //top.add(category);
			}

		}
    }
        

}
